# 演算子
算術演算子: `+, -, *, /, //, %, **`
比較演算子: `==, !=, <=, >=, <, >`
論理演算子: `not, and, or`

注意: ゲーム内のすべての数値は浮動小数点数です。したがって、すべての算術演算子は浮動小数点演算子です。
`//` は除算後の数値を切り捨てるように定義されています。

代入演算子を使用するには、「変数」のアンロックが必要です。

## はじめに
演算子を使用すると、値を比較、変更、結合できます。
算術演算子 `+, -, *, /, //, %, **` は、数値に対して一般的な数学的操作を実行するために使用されます。
比較演算子 `==, !=, <=, >=, <, >` は、値を比較するために使用されます。結果は常に `True` または `False` のいずれかです。
論理演算子（ブール演算子とも呼ばれます） `not, and, or` は、真理値を結合するために使用されます。

## 算術演算子
`+` と `-` は加算と減算に使用されます。

`2 + 3` は `5` と評価されます。
`3 - 2` は `1` と評価されます。

`*`, `/`, `//` は乗算と除算に使用されます。

`2 * 3` は `6` と評価されます。
`5 / 2` は `2.5` と評価されます。

`//` は `/` と同じことをしますが、結果は切り捨てられます（次の整数に丸められます）。

`5 // 2` は `2` と評価されます。

`%` はモジュロ演算子で、剰余演算子としても知られています。基本的には2つの数値を割り、その余りを返します。また、余りが右の数値より小さくなるまで、左の数値から右の数値を繰り返し引くものと考えることもできます。

`4 % 2` は `0` と評価されます。
`5 % 2` は `1` と評価されます。
`6 % 2` は `0` と評価されます。
`2 % 6` は `2` と評価されます。
`1.5 % 1` は `0.5` と評価されます。

`**` はべき乗演算子です。

`2**2` は `4` と評価されます。
`(-5)**3` は `-125` と評価されます。

## 比較演算子
`==` と `!=` は、2つの値が「等しい」(`==`)か「等しくない」(`!=`)かを確認するために使用されます。これらはすべてのタイプの値に使用できます。

`2 == 2` は `True` と評価されます。
`Entities.Bush != Entities.Bush` は `False` と評価されます。
`3 != 3 + 1` は `True` と評価されます。

`<=, >=, <, >` は数値にのみ使用できます。左の数値が右の数値より「小さいか等しい」(`<=`)、「大きいか等しい」(`>=`)、「小さい」(`<`)、「大きい」(`>`)かをチェックします。

`1 <= 1` は `True` と評価されます。
`2 >= 3` は `False` と評価されます。
`-2 < -1` は `True` と評価されます。
`6 > 6` は `False` と評価されます。

## 論理演算子
`not` は単に値を反転させます:

`not False` は `True` と評価されます。
`not True` は `False` と評価されます。

`and` は両方の値が `True` の場合にのみ `True` と評価されます。

`True and True` は `True` と評価されます。
`True and False` は `False` と評価されます。
`False and False` は `False` と評価されます。

`or` は少なくとも一方の値が `True` の場合に `True` と評価されます。

`True or True` は `True` と評価されます。
`True or False` は `True` と評価されます。
`False or False` は `False` と評価されます。